class KeyBinder
{
    function Init()
    {
        theInput.RegisterListener(this, 'OnSun', 'Sun');
        theInput.RegisterListener(this, 'OnRain', 'Rain');
        theInput.RegisterListener(this, 'OnGeraltReset', 'GeraltReset');
		theInput.RegisterListener(this, 'OnKillThemAll', 'KillThemAll');
		theInput.RegisterListener(this, 'OnStaminaRestore', 'StaminaRestore');
		theInput.RegisterListener(this, 'OnHealthRestore', 'HealthRestore');
		theInput.RegisterListener(this, 'OnQuickLevel', 'QuickLevel');
		theInput.RegisterListener(this, 'OnNewSkills', 'NewSkills');
		theInput.RegisterListener(this, 'OnTravel', 'Travel');
		theInput.RegisterListener(this, 'OnNoTravel', 'NoTravel');
	}
    event OnSun( action : SInputAction )
    {
        if(IsPressed(action))
            RequestWeatherChangeTo('WT_Clear', 1.0, false);
    }
    event OnRain( action : SInputAction )
    {
        if(IsPressed(action))
            RequestWeatherChangeTo('WT_Rain_Storm', 1.0, false);
    }
    event OnTravel( action : SInputAction )
    {
        if(IsPressed(action))
            theGame.getMapLinker().enable();
    }
    event OnNoTravel( action : SInputAction )
    {
        if(IsPressed(action))
            theGame.getMapLinker().disable();
    }
    event OnGeraltReset( action : SInputAction )
    {
        if(IsPressed(action))
            GetWitcherPlayer().Debug_ClearCharacterDevelopment();
    }	
    event OnHealthRestore( action : SInputAction )
    {
        if(IsPressed(action))
            thePlayer.GainStat(BCS_Vitality, 900000);
    }	
    event OnQuickLevel( action : SInputAction )
    {
		var lm : W3PlayerWitcher;
		var i,exp : int;
		var times : int;

        if(IsPressed(action))
		{	
			if(times < 1)
				times = 1;
				
			lm = GetWitcherPlayer();
			for(i=0; i<times; i+=1)
			{
				exp = lm.GetTotalExpForNextLevel() - lm.GetPointsTotal(EExperiencePoint);
				lm.AddPoints(EExperiencePoint, exp, false );
			}	
		}
    }	
    event OnNewSkills( action : SInputAction )
    {
        if(IsPressed(action))
            GetWitcherPlayer().levelManager.AddPoints(ESkillPoint,2, true);
    }	
    event OnStaminaRestore( action : SInputAction )
    {
		var val : int;
		
        if(IsPressed(action))
		{
			if( val == 0 )
			{
				val = 1000;
			}
			
			thePlayer.GainStat( BCS_Stamina, val );
		}	
    }	
    event OnKillThemAll( action : SInputAction )
    {
		var enemies: array<CActor>;
		var i, enemiesSize : int;
		var npc : CNewNPC;
		var range : float = 20.f;

		if(IsPressed(action))
		{	
			enemies = GetActorsInRange(thePlayer, range);
			
			enemiesSize = enemies.Size();
			
			for( i = 0; i < enemiesSize; i += 1 )
			{
				npc = (CNewNPC)enemies[i];
				
				if( npc )
				{
					if( npc.GetAttitude( thePlayer ) == AIA_Hostile )
					{
						npc.Kill( 'Debug' );
					}
				}
			}
		}	
    }	
}